/*****************************************
* Klasse Puffer
* 
* Beschreibung: Puffer zum Speicher von bytes. Diese Klasse ist eine Modification des Vector-Klasse von SUN. Bechreibung der Methoden siehe in der Vektor-Klasse
*****************************************/



import java.util.Enumeration;
import java.util.NoSuchElementException;


   public class Puffer {

    protected byte elementData[];
    protected int elementCount;
    protected int capacityIncrement;

    public Puffer(int initialCapacity, int capacityIncrement) {
	super();
	this.elementData = new byte[initialCapacity];
	this.capacityIncrement = capacityIncrement;
    }


    public Puffer(int initialCapacity) {
	this(initialCapacity, 0);
    }

    public Puffer() {
	this(2048);//2048
    }


    public final synchronized void copyInto(byte anArray[]) {
	int i = elementCount;
	while (i-- > 0) {
	    anArray[i] = elementData[i];
	}
    }


    public final synchronized void trimToSize() {
	int oldCapacity = elementData.length;
	if (elementCount < oldCapacity) {
	    byte oldData[] = elementData;
	    elementData = new byte[elementCount];
	    System.arraycopy(oldData, 0, elementData, 0, elementCount);
	}
    }


    public final synchronized void ensureCapacity(int minCapacity) {
	int oldCapacity = elementData.length;
	if (minCapacity > oldCapacity) {
	    byte oldData[] = elementData;
	    int newCapacity = (capacityIncrement > 0) ?
		(oldCapacity + capacityIncrement) : (oldCapacity * 2);
    	    if (newCapacity < minCapacity) {
		newCapacity = minCapacity;
	    }
	    elementData = new byte[newCapacity];
	    System.arraycopy(oldData, 0, elementData, 0, elementCount);
	}
    }


    public final synchronized void setSize(int newSize) {
	if (newSize > elementCount) {
	    ensureCapacity(newSize);
	} else {
	    for (int i = newSize ; i < elementCount ; i++) {
		elementData[i] = 0;
	    }
	}
	elementCount = newSize;
    }


    public final int capacity() {
	return elementData.length;
    }


    public final int size() {
	return elementCount;
    }


    public final boolean isEmpty() {
	return elementCount == 0;
    }


    public final synchronized byte elementAt(int index) {
	if (index >= elementCount) {
	    throw new ArrayIndexOutOfBoundsException(index + " >= " + elementCount);
	}

	try {
	    return elementData[index];
	} catch (ArrayIndexOutOfBoundsException e) {
	    throw new ArrayIndexOutOfBoundsException(index + " < 0");
	}
    }

    public final synchronized byte firstElement() {
	if (elementCount == 0) {
	    throw new NoSuchElementException();
	}
	return elementData[0];
    }

    public final synchronized byte lastElement() {
	if (elementCount == 0) {
	    throw new NoSuchElementException();
	}
	return elementData[elementCount - 1];
    }


    public final synchronized void setElementAt(byte obj, int index) {
	if (index >= elementCount) {
	    throw new ArrayIndexOutOfBoundsException(index + " >= " +
						     elementCount);
	}
	elementData[index] = obj;
    }


    public final synchronized void removeElementAt(int index) {
	if (index >= elementCount) {
	    throw new ArrayIndexOutOfBoundsException(index + " >= " +
						     elementCount);
	}
	int j = elementCount - index - 1;
	if (j > 0) {
	    System.arraycopy(elementData, index + 1, elementData, index, j);
	}
	elementCount--;
	elementData[elementCount] = 0;
    }


    public final synchronized void insertElementAt(byte obj, int index) {
	if (index >= elementCount + 1) {
	    throw new ArrayIndexOutOfBoundsException(index + " >= " +
						     elementCount + 1);
	}
	ensureCapacity(elementCount + 1);
	System.arraycopy(elementData, index, elementData, index + 1, elementCount - index);
	elementData[index] = obj;
	elementCount++;
    }


    public final synchronized void addElement(byte obj) {
	ensureCapacity(elementCount + 1);
	elementData[elementCount++] = obj;
    }

    public final int indexOf(byte elem) {
	return indexOf(elem, 0);
    }

     public final synchronized int indexOf(byte elem, int index) {
	for (int i = index ; i < elementCount ; i++) {
	    if (elem == elementData[i]) {
		return i;
	    }
	}
	return -1;
    }

    public final synchronized boolean removeElement(byte obj) {
	int i = indexOf(obj);
	if (i >= 0) {
	    removeElementAt(i);
	    return true;
	}
	return false;
    }


    public final synchronized void removeAllElements() {
	for (int i = 0; i < elementCount; i++) {
	    elementData[i] = 0;
	}
	elementCount = 0;
    }

}
